unit fROR_RegistryInfo;
{
================================================================================
*
*       Package:        ROR - Clinical Case Registries
*       Date Created:   $Revision: 7 $  $Modtime: 3/07/07 3:24p $
*       Site:           Hines OIFO
*       Developers:     Andrey Andriyevskiy
*
*       Description:    Form Registry information window
*
*       Notes:
*
================================================================================
*       $Archive: /CCR v1.5/Current/fROR_RegistryInfo.pas $
*
* $History: fROR_RegistryInfo.pas $
 * 
 * *****************  Version 7  *****************
 * User: Vhaishgavris Date: 3/08/07    Time: 1:47p
 * Updated in $/CCR v1.5/Current
 * 
 * *****************  Version 6  *****************
 * User: Vhaishgavris Date: 11/14/05   Time: 9:38a
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 5  *****************
 * User: Vhaishgavris Date: 5/17/05    Time: 1:50p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 4  *****************
 * User: Vhaishgavris Date: 1/10/05    Time: 3:48p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 3  *****************
 * User: Vhaishgavris Date: 10/14/04   Time: 3:50p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 2  *****************
 * User: Vhaishgavris Date: 6/24/04    Time: 3:22p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 1  *****************
 * User: Vhaishgavris Date: 9/11/03    Time: 5:03p
 * Created in $/ICR v3.0/Current
 * 
 * *****************  Version 2  *****************
 * User: Vhaishandria Date: 8/01/03    Time: 9:48a
 * Updated in $/ICR v3.0/Current
 * Build 63
*
* *****************  Version 1  *****************
* User: Vhaishandria Date: 7/30/03    Time: 1:50p
* Created in $/ICR v3.0/Current
================================================================================
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, Buttons;

type
  TFormRegistryInfo = class(TForm)
    btnOK: TBitBtn;
    pnlInfo: TPanel;
    stxtRegistryNameLabel: TStaticText;
    stxtRegistryName: TStaticText;
    stxtDescLabel: TStaticText;
    stxtNationalRegLabel: TStaticText;
    stxtLastUpdateLabel: TStaticText;
    stxtLastExtractLabel: TStaticText;
    stxtNumActiveLabel: TStaticText;
    stxtNumPendingLabel: TStaticText;
    stxtStatusLabel: TStaticText;
    stxtDesc: TStaticText;
    stxtNationalReg: TStaticText;
    stxtLastUpdate: TStaticText;
    stxtLastExtract: TStaticText;
    stxtNumActive: TStaticText;
    stxtNumPending: TStaticText;
    stxtStatus: TStaticText;
    stxtVersionLabel: TStaticText;
    stxtServerVersLabel: TStaticText;
    stxtPatchLabel: TStaticText;
    stxtPatchDateLabel: TStaticText;
    stxtServerVers: TStaticText;
    stxtPatch: TStaticText;
    stxtPatchDate: TStaticText;
  end;

  function ShowInfo(const anIEN: String): Boolean;

implementation

uses uROR_Utilities, uROR_Broker, uROR_Common, uROR_Classes;

{$R *.DFM}

function ShowInfo(const anIEN: String): Boolean;
var
  i: integer;
begin
  try
    Result := False;
    Broker.CreateResults;

    with TFormRegistryInfo.Create(Application) do
      try
        if Broker.CallProc(rpcGetRegistryInfo, [anIEN]) then
        begin
          stxtRegistryName.Caption := piece(Broker.Results[1],'^',2);
          stxtDesc.Caption := Broker.Results[3];
          if Broker.Results[2] = '1' then
            stxtNationalReg.Caption := 'Yes'
          else
            stxtNationalReg.Caption := 'No';
          stxtLastUpdate.Caption := FMDateTimeStr(Broker.Results[4]);
          stxtLastExtract.Caption := FMDateTimeStr(Broker.Results[5]);
          stxtNumActive.Caption := Broker.Results[6];
          stxtNumPending.Caption := Broker.Results[7];
          stxtStatus.Caption := piece(Broker.Results[8],'^',2);
          stxtServerVers.Caption := piece(Broker.Results[10],'^',1);
          stxtPatch.Caption := piece(Broker.Results[10],'^',2);
          stxtPatchDate.Caption := FMDateTimeStr(piece(Broker.Results[10],'^',3));

          if CCRScreenReaderActive then
          begin
            for i := 0 to ComponentCount - 1 do
            begin
              if (Components[i] is TStaticText) then
              begin
                with TStaticText(Components[i]) do
                  if length(Caption) > 0 then
                    TabStop := true;
              end;
            end;
          end;
          SetFocusedControl(btnOK);

          ShowModal;
          Result := True;
        end;
      finally
        Free;
      end;
  except
    Result := False;
  end;
end;

end.
